/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util.block;

import com.tacz.guns.config.common.AmmoConfig;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2374;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class BlockRayTrace {
    private static final Predicate<class_2680> IGNORES = input -> input != null && (input.method_26204() instanceof class_2397 || input.method_26204() instanceof class_2354 || input.method_27852(class_2246.field_10576) || input.method_26204() instanceof class_2349);

    public static class_3965 rayTraceBlocks(class_1937 world, class_3959 context) {
        return BlockRayTrace.performRayTrace(context, (rayTraceContext, blockPos) -> {
            class_2960 blockId;
            class_2680 blockState = world.method_8320(blockPos);
            List ids = (List)AmmoConfig.PASS_THROUGH_BLOCKS.get();
            if (ids.contains((blockId = class_7923.field_41175.method_10221((Object)blockState.method_26204())).toString())) {
                return null;
            }
            if (IGNORES.test(blockState)) {
                return null;
            }
            return BlockRayTrace.getBlockHitResult(world, rayTraceContext, blockPos, blockState);
        }, rayTraceContext -> {
            class_243 vec3 = rayTraceContext.method_17750().method_1020(rayTraceContext.method_17747());
            return class_3965.method_17778((class_243)rayTraceContext.method_17747(), (class_2350)class_2350.method_10142((double)vec3.field_1352, (double)vec3.field_1351, (double)vec3.field_1350), (class_2338)class_2338.method_49638((class_2374)rayTraceContext.method_17747()));
        });
    }

    @Nullable
    private static class_3965 getBlockHitResult(class_1937 world, class_3959 rayTraceContext, class_2338 blockPos, class_2680 blockState) {
        class_3610 fluidState = world.method_8316(blockPos);
        class_243 startVec = rayTraceContext.method_17750();
        class_243 endVec = rayTraceContext.method_17747();
        class_265 blockShape = rayTraceContext.method_17748(blockState, (class_1922)world, blockPos);
        class_3965 blockResult = world.method_17745(startVec, endVec, blockPos, blockShape, blockState);
        class_265 fluidShape = rayTraceContext.method_17749(fluidState, (class_1922)world, blockPos);
        class_3965 fluidResult = fluidShape.method_1092(startVec, endVec, blockPos);
        double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.method_17750().method_1025(blockResult.method_17784());
        double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.method_17750().method_1025(fluidResult.method_17784());
        return blockDistance <= fluidDistance ? blockResult : fluidResult;
    }

    private static <T> T performRayTrace(class_3959 context, BiFunction<class_3959, class_2338, T> hitFunction, Function<class_3959, T> missFactory) {
        class_243 endVec;
        class_243 startVec = context.method_17750();
        if (!startVec.equals((Object)(endVec = context.method_17747()))) {
            int blockZ;
            int blockY;
            double startX = class_3532.method_16436((double)-1.0E-7, (double)endVec.field_1352, (double)startVec.field_1352);
            double startY = class_3532.method_16436((double)-1.0E-7, (double)endVec.field_1351, (double)startVec.field_1351);
            double startZ = class_3532.method_16436((double)-1.0E-7, (double)endVec.field_1350, (double)startVec.field_1350);
            double endX = class_3532.method_16436((double)-1.0E-7, (double)startVec.field_1352, (double)endVec.field_1352);
            double endY = class_3532.method_16436((double)-1.0E-7, (double)startVec.field_1351, (double)endVec.field_1351);
            double endZ = class_3532.method_16436((double)-1.0E-7, (double)startVec.field_1350, (double)endVec.field_1350);
            int blockX = class_3532.method_15357((double)endX);
            class_2338.class_2339 mutablePos = new class_2338.class_2339(blockX, blockY = class_3532.method_15357((double)endY), blockZ = class_3532.method_15357((double)endZ));
            T t = hitFunction.apply(context, (class_2338)mutablePos);
            if (t != null) {
                return t;
            }
            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = class_3532.method_17822((double)deltaX);
            int signY = class_3532.method_17822((double)deltaY);
            int signZ = class_3532.method_17822((double)deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0 - class_3532.method_15385((double)endX) : class_3532.method_15385((double)endX));
            double d13 = d10 * (signY > 0 ? 1.0 - class_3532.method_15385((double)endY) : class_3532.method_15385((double)endY));
            double d14 = d11 * (signZ > 0 ? 1.0 - class_3532.method_15385((double)endZ) : class_3532.method_15385((double)endZ));
            while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
                T t1;
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
                if ((t1 = hitFunction.apply(context, (class_2338)mutablePos.method_10103(blockX, blockY, blockZ))) == null) continue;
                return t1;
            }
        }
        return missFactory.apply(context);
    }
}

